//=============================================================================
// TeamDeathMatch
//=============================================================================
class TeamDMGame expands DeusExMPGame;

var int TeamScore[2];

var localized String EnemiesString, AlliesString, VictoryConString1, VictoryConString2, TimeLimitString1, TimeLimitString2;
var localized String TeamScoreString;
var ScoreElement teamSE[32];	
var int	NumSupportingPlayer; 
var bool bSpawnInTeamArea;
var name CurrentOrders[2];

event PlayerPawn Login(string Portal, string Options, out string Error, class<playerpawn> SpawnClass)
{
   local PlayerPawn newPlayer;
   local int TeamOption;
   local string StringTeamOption;

   TeamOption = TEAM_AUTO;
   if (HasOption(Options,"Team"))
   {
      StringTeamOption = ParseOption(Options,"Team");
	  if (StringTeamOption != "")
		  TeamOption = int(StringTeamOption);
   }

   if (!ApproveTeam(TeamOption))
	   TeamOption = TEAM_AUTO;

   if (TeamOption == TEAM_AUTO)
      TeamOption = GetAutoTeam();

   if (TeamOption == TEAM_UNATCO)
      SpawnClass = class'MPUnatco';
   else if (TeamOption == TEAM_NSF)
      SpawnClass = class'MPNSF';

   ChangeOption(Options,"Team",string(TeamOption));

   newPlayer = Super.Login(Portal, Options, Error, SpawnClass);

   newPlayer.bAutoActivate = true;

   return newPlayer;
}

event PostLogin(playerpawn NewPlayer)
{
   local DeusExPlayer DXPlayer;

   DXPlayer = DeusExPlayer(NewPlayer);	
   SetTeam( DXPlayer );

   Super.PostLogin(NewPlayer);
}

function Logout(pawn Exiting)
{
    Super.Logout(Exiting);
    ClearOrders(Exiting);
}

function bool ApproveTeam(int CheckTeam)
{
	if (CheckTeam == TEAM_UNATCO)
		return true;
	if (CheckTeam == TEAM_NSF)
		return true;
	if (CheckTeam == TEAM_AUTO)
		return true;

	return false;
}

function Bot SpawnBot(out NavigationPoint StartSpot)
{
	local Bot NewBot;
	local int BotN;
        local int j;
        local Pawn P;

        Difficulty = BotConfig.Difficulty;

	if ( Difficulty >= 4 )
	{
		bNoviceMode = false;
		Difficulty = Difficulty - 4;
	}
	else
	{
		if ( Difficulty > 3 )
		{
			Difficulty = 3;
			bThreePlus = true;
		}
		bNoviceMode = true;
	}
	
	BotN = GetAutoTeam();
        j = BotConfig.ChooseBotInfo();

	StartSpot = FindPlayerStart(None, 255);
	if( StartSpot == None )
	{
		log("Could not find starting spot for Bot");
		return None;
	}

	NewBot = Spawn(BotConfig.GetTeamBotClass(BotN),,,StartSpot.Location,StartSpot.Rotation);
        
	if ( NewBot == None )
		log("Couldn't spawn bot at "$StartSpot);

	if ( (bHumansOnly || Level.bHumansOnly) && !NewBot.bIsHuman )
	{
		log("can't add non-human bot to this game");
		NewBot.Destroy();
		NewBot = None;
	}

	if ( NewBot != None )
	{
		NewBot.PlayerReplicationInfo.PlayerID = CurrentID++;
                BotConfig.SetBotSkill(NewBot);
                BotConfig.CHIndividualize(NewBot, j, NumBots);
                NewBot.UnfamiliarName = NewBot.PlayerReplicationInfo.PlayerName;
                AddDefaultInventory(NewBot);

                if (NewBot.IsA('Bot_UN'))
                    NewBot.PlayerReplicationInfo.Team = TEAM_UNATCO;
                else if (NewBot.IsA('Bot_NSF'))
                    NewBot.PlayerReplicationInfo.Team = TEAM_NSF;
                
		NewBot.ViewRotation = StartSpot.Rotation;
		BroadcastMessage( NewBot.PlayerReplicationInfo.PlayerName$EnteredMessage, false );
                NewBot.AirControl = AirControl;
         	NumBots++;	
	}
	return NewBot;
}

function Actor SetDefenseFor(Bot aBot)
{
	return None;
}

function bool HandleTieUp(Bot Bumper, Bot Bumpee)
{
	return false;
}

function byte PriorityObjective(Bot aBot)
{
	return 0;
}

function bool WaitForPoint(bot aBot)
{
	return false;
}

function bool SendBotToGoal(Bot aBot)
{
	return false;
}

function byte AssessBotAttitude(Bot aBot, Pawn Other)
{
	if (Other.bIsPlayer && (aBot.PlayerReplicationInfo.Team == Other.PlayerReplicationInfo.Team))		 
		return 3;
	else 
		return Super.AssessBotAttitude(aBot, Other);
}

function int GetAutoTeam()
{
   local int NumUNATCO;
   local int NumNSF;
   local int CurTeam;
   local Pawn CurPawn;

   NumUNATCO = 0;
   NumNSF = 0;

   for (CurPawn = Level.Pawnlist; CurPawn != None; CurPawn = CurPawn.NextPawn)
   {
      if ((CurPawn != None) && (CurPawn.PlayerReplicationInfo != None))
      {

         CurTeam = CurPawn.PlayerReplicationInfo.Team;
         if (CurTeam == TEAM_UNATCO)
         {
            NumUNATCO++;
         }
         else if (CurTeam == TEAM_NSF)
         {
            NumNSF++;
         }
      }
   }

   if (NumUNATCO < NumNSF)
      return TEAM_UNATCO;
   else if (NumUNATCO > NumNSF)
      return TEAM_NSF;
   else
      return TEAM_UNATCO;
}

function ChangeOption(out string Options, string OptionKey, string NewValue)
{
   local string NewOptions;//new option string
   local string CurOption;
   local string CurKey;
   local string CurValue;

   NewOptions = "";

   while (GrabOption(Options,CurOption))
   {
      GetKeyValue(CurOption, CurKey, CurValue);
      if (CurKey ~= OptionKey)
         CurValue = NewValue;
      NewOptions = NewOptions $ "?" $ CurKey $ "=" $ CurValue;
   }

   Options = NewOptions;
}

simulated function bool ArePlayersAllied(Pawn FirstPlayer, Pawn SecondPlayer)
{
   if ((FirstPlayer == None) || (SecondPlayer == None))
      return false;
   return (FirstPlayer.PlayerReplicationInfo.team == SecondPlayer.PlayerReplicationInfo.team);
}

function int ReduceDamage(int Damage, name DamageType, pawn injured, pawn instigatedBy)
{
	Damage = Super.ReduceDamage(Damage, DamageType, injured, instigatedBy);
	
	if ( instigatedBy == None )
		return Damage;

	if ( (instigatedBy != injured) && injured.bIsPlayer && instigatedBy.bIsPlayer 
		&& (injured.PlayerReplicationInfo.Team == instigatedBy.PlayerReplicationInfo.Team) )
	{
                	if ( injured.IsA('Bot') )
			Bot(Injured).YellAt();
                	else if ( injured.IsA('ScriptedBot') )
			ScriptedBot(Injured).YellAt();
		return ( Damage * fFriendlyFireMult );
	}
	else
		return Damage;
}

simulated function TeamWinScreen( DeusExPlayer thisPlayer, GC gc, float screenWidth, float screenHeight, int winningTeam,
											String killerStr, String killeeStr, String methodStr )
{
	local String str;
	local float x, y, w, h;

	// Show who won the match
	if ( thisPlayer.PlayerReplicationInfo.team == winningTeam )
		gc.SetTextColor( GreenColor );
	else
		gc.SetTextColor( RedColor );

	gc.SetFont(Font'FontMenuExtraLarge');

	switch( winningTeam )
	{
		case TEAM_NSF:
			str = TeamNsfString $ WonMatchString;
			break;
		case TEAM_UNATCO:
			str = TeamUnatcoString $ WonMatchString;
			break;
		case TEAM_DRAW:
			str = TeamDrawString;
			break;
	}

	gc.GetTextExtent( 0, w, h, str );
	x = (screenWidth * 0.5) - (w * 0.5);
	y = screenHeight * WinY;
	gc.DrawText( x, y, w, h, str );

	y += h;

	// Show who won it and who got killed
	if ( VictoryCondition ~= "Frags" )
	{
		gc.SetFont(Font'FontMenuTitle');
		if (( killerStr ~= "" ) || (killeeStr ~= ""))
			log( "Warning:Bad kill string in final death message." );
		else
		{
			str = MatchEnd1String $ killerStr $ MatchEnd2String $ killeeStr $ methodStr;
			gc.GetTextExtent( 0, w, h, str );
			if ( w >= screenWidth )
			{
				y -= (h * 0.5);
				str = MatchEnd1String $ killerStr $ MatchEnd2String $ killeeStr;
				gc.GetTextExtent( 0, w, h, str );
				x = (screenWidth * 0.5) - (w * 0.5);
				gc.DrawText( x, y, w, h, str );
				y += h;
				str = methodStr;
				gc.GetTextExtent( 0, w, h, str );
				x = (screenWidth * 0.5) - (w * 0.5);
				gc.DrawText( x, y, w, h, str );

			}
			else
			{
				x = (screenWidth * 0.5) - (w * 0.5);
				gc.DrawText( x, y, w, h, str );
			}
		}
	}

	// Show the scoreboard for all to see
	ShowTeamDMScoreboard( thisPlayer, gc, screenWidth, screenHeight );

	// Press fire to continue message
	ContinueMsg( gc, screenWidth, screenHeight );
}

function SetTeam( DeusExPlayer player )
{
	if ( player.IsA('MPUnatco'))
	{
		player.PlayerReplicationInfo.Team = TEAM_UNATCO;
		player.MultiplayerNotifyMsg( player.MPMSG_TeamUnatco );
	}
	else if ( player.IsA('MPNsf'))
	{
		player.PlayerReplicationInfo.Team = TEAM_NSF;
		player.MultiplayerNotifyMsg( player.MPMSG_TeamNsf );
	}
	else
		log( "Warning: Player:"$player$" has chosen an invalid team!" );
}

simulated function int GetTeamList( DeusExPlayer player, bool Allies )
{
	local int i, numTeamList;

	if ( player == None )
		return( 0 );

	numTeamList = 0;

	for ( i = 0; i < scorePlayers; i++ )
	{
		if ( (Allies && (scoreArray[i].Team == player.PlayerReplicationInfo.Team) ) ||
			  (!Allies && (scoreArray[i].Team != player.PlayerReplicationInfo.Team) ) )
		{
				teamSE[numTeamList] = scoreArray[i];
				numTeamList += 1;
		}
	}
	return( numTeamList );
}

function CalcTeamScores()
{
	local Pawn curPawn;

	TeamScore[TEAM_NSF] = 0;
	TeamScore[TEAM_UNATCO] = 0;

	// This only happens once per kill on the server
	curPawn = Level.PawnList;
	while ( curPawn != None )
	{
               if ( curPawn.bIsPlayer )
                 {
			if (curPawn.PlayerReplicationInfo.team == TEAM_NSF )
				TeamScore[TEAM_NSF] += int(curPawn.PlayerReplicationInfo.Score);
			if (curPawn.PlayerReplicationInfo.team == TEAM_UNATCO )
				TeamScore[TEAM_UNATCO] += int(curPawn.PlayerReplicationInfo.Score);
                 } 
		
		curPawn = curPawn.nextPawn;
	}
}

simulated function bool TeamFinalCheckScores()
{
	local int i, nsfScore, unatcoScore;

	nsfScore = 0;
	unatcoScore = 0;
	for ( i = 0; i < scorePlayers; i++ )
	{
		if ( scoreArray[i].team == TEAM_NSF )
			nsfScore += (scoreArray[i].score);
		else if ( scoreArray[i].team == TEAM_UNATCO )
			unatcoScore += (scoreArray[i].score);
	}
	if ( (nsfScore >= ScoreToWin) || (unatcoScore >= ScoreToWin))
		return True;
	else
		return False;
}

function TeamHasWon( int team, Pawn Killer, Pawn Killee, String Method )
{
	local Pawn curPawn;
	local String str, killerStr, killeeStr;

	PreGameOver();

	killerStr = ""; killeeStr = "";
	if (( Killer != None ) && ( Killee != None ))
	{
		killerStr = Killer.PlayerReplicationInfo.PlayerName;
		killeeStr = Killee.PlayerReplicationInfo.PlayerName;
	}

	if ( team == TEAM_UNATCO )
		str = TeamUnatcoString;
	else
		str = TeamNsfString;

	curPawn = Level.PawnList;
	while ( curPawn != None )
	{
		if ( curPawn.IsA('DeusExPlayer') )
		{
			DeusExPlayer(curPawn).ShowMultiplayerWin( str, team, killerStr, killeeStr, Method );
		}
		curPawn = curPawn.nextPawn;
	}

   GameOver();
}

function bool CheckVictoryConditions(Pawn Killer, Pawn Killee, String Method)
{
	local float timeLimit;

	CalcTeamScores();

	if ( VictoryCondition ~= "Frags" )
	{	
		if (( TeamScore[TEAM_UNATCO] == ScoreToWin-(ScoreToWin/5)) && ( ScoreToWin >= 10 ))
			NotifyGameStatus( ScoreToWin/5, TeamUnatcoString, False, False );
		if (( TeamScore[TEAM_UNATCO] == ScoreToWin - 1 ) && (ScoreTowin >= 2 ))
			NotifyGameStatus( 1, TeamUnatcoString, False, True );
		if (( TeamScore[TEAM_NSF] == ScoreToWin-(ScoreToWin/5)) && ( ScoreToWin >= 10 ))
			NotifyGameStatus( ScoreToWin/5, TeamNsfString, False, False );
		if (( TeamScore[TEAM_NSF] == ScoreToWin-1 ) && (ScoreTowin >= 2 ))
			NotifyGameStatus( 1, TeamNsfString, False, True );

		if ( TeamScore[TEAM_UNATCO] >= ScoreToWin )
		{
			TeamHasWon( TEAM_UNATCO, Killer, Killee, Method );
			return true;
		}
		if ( TeamScore[TEAM_NSF] >= ScoreToWin )
		{
			TeamHasWon( TEAM_NSF, Killer, Killee, Method );
			return true; 
		}
	}
	else if ( VictoryCondition ~= "Time" )
	{
		timeLimit = float(ScoreToWin)*60.0;

		if (( Level.Timeseconds >= (timeLimit-NotifyMinutes*60.0) ) && ( timeLimit >= NotifyMinutes*60.0*2.0 ))
		{
			if ( TeamScore[TEAM_UNATCO] > TeamScore[TEAM_NSF] )
				NotifyGameStatus( int(NotifyMinutes), TeamUnatcoString, True, True );
			else if ( TeamScore[TEAM_UNATCO] == TeamScore[TEAM_NSF] )
				NotifyGameStatus( int(NotifyMinutes), "Tied", True, True );
			else
				NotifyGameStatus( int(NotifyMinutes), TeamNsfString, True, True );
		}

		if ( Level.Timeseconds >= timeLimit )
		{
			if ( TeamScore[TEAM_UNATCO] > TeamScore[TEAM_NSF] )
			{
				TeamHasWon( TEAM_UNATCO, Killer, Killee, Method );
				return true;
			}
			else if ( TeamScore[TEAM_UNATCO] < TeamScore[TEAM_NSF] )
			{
				TeamHasWon( TEAM_NSF, Killer, Killee, Method );
				return true;
			}
			else
			{
				TeamHasWon( TEAM_DRAW, Killer, Killee, Method );
				return true;
			}
		}
	}
	else
		log( "Warning: Unknown victory type:"$VictoryCondition$" " );

	return false;
}

simulated function ShowVictoryConditions( GC gc, float screenWidth, float yoffset, DeusExPlayer thisPlayer )
{
	local String str, secStr;
	local float x, y, w, h;
	local int minutesLeft, secondsLeft, timeLeft;
	local float ftimeLeft;

	if ( VictoryCondition ~= "Frags" )
		str = VictoryConString1 $ ScoreToWin $ VictoryConString2;
	else if ( VictoryCondition ~= "Time" )
	{
		timeLeft = ScoreToWin * 60 - Level.Timeseconds - thisPlayer.ServerTimeDiff;
		if ( timeLeft < 0 )
			timeleft = 0;
		minutesLeft = timeLeft/60;
		ftimeLeft = float(timeLeft);
		secondsLeft = int(ftimeLeft%60);
		if ( secondsLeft < 10 )
			secStr = "0" $ secondsLeft;
		else
			secStr = "" $ secondsLeft;

		str = TimeLimitString1 $ minutesLeft $ ":" $ secStr $ TimeLimitString2;
	}
	else
		log( "Warning: Unknown victory type:"$VictoryCondition$" " );

	gc.GetTextExtent( 0, w, h, str );
	x = (screenWidth * 0.5) - (w * 0.5);
	gc.DrawText( x, yoffset, w, h, str );
}

simulated function SortTeamScores( int PlayerCount )
{
	local ScoreElement tmpSE;
	local int i, j, max;
	
	for ( i = 0; i < PlayerCount-1; i++ )
	{
		max = i;
		for ( j = i+1; j < PlayerCount; j++ )
		{
			if ( teamSE[j].Score > teamSE[max].Score )
				max = j;
			else if (( teamSE[j].Score == teamSE[max].Score) && (teamSE[j].Deaths < teamSE[max].Deaths))
				max = j;
		}
		tmpSE = teamSE[max];
		teamSE[max] = teamSE[i];
		teamSE[i] = tmpSE;
	}
}

simulated function LocalGetTeamTotals( int teamSECnt, out float score, out float deaths, out float streak )
{
	local int i;

	score = 0; deaths = 0; streak = 0;
	for ( i = 0; i < teamSECnt; i++ )
	{
		score += teamSE[i].Score;
		deaths += teamSE[i].Deaths;
		streak += teamSE[i].Streak;
	}
}

simulated function ShowTeamDMScoreboard( DeusExPlayer thisPlayer, GC gc, float screenWidth, float screenHeight )
{
	local float yoffset, ystart, xlen, ylen, w, h, w2;
	local bool bLocalPlayer;
	local int i, allyCnt, enemyCnt, barLen;
	local ScoreElement fakeSE;
	local String str, teamStr;

	if ( !thisPlayer.PlayerIsClient() && (Level.NetMode != NM_Standalone))
		return;

	// Always use this font
	gc.SetFont(Font'FontMenuSmall');
	str = "TEST";
	gc.GetTextExtent( 0, xlen, ylen, str );

	// Refresh out local array
	RefreshScoreArray( thisPlayer );

	// Just allies
	allyCnt = GetTeamList( thisPlayer, True );
	SortTeamScores( allyCnt );

	ystart = screenHeight * PlayerY;
	yoffset = ystart;

	// Headers
	gc.SetTextColor( WhiteColor );
	ShowVictoryConditions( gc, screenWidth, ystart, thisPlayer );
	yoffset += (ylen * 2.0);
	DrawHeaders( gc, screenWidth, yoffset );
	yoffset += (ylen * 1.5);

	if ( thisPlayer.PlayerReplicationInfo.team == TEAM_UNATCO )
		teamStr = TeamUnatcoString;
	else
		teamStr = TeamNsfString;

	// Allies
	gc.SetTextColor( GreenColor );
	fakeSE.PlayerName = AlliesString $ " (" $ teamStr $ ")";
	LocalGetTeamTotals( allyCnt, fakeSE.score, fakeSE.deaths, fakeSE.streak );
	DrawNameAndScore( gc, fakeSE, screenWidth, yoffset );
	gc.GetTextExtent( 0, w, h, StreakString );
	barLen = (screenWidth * StreakX + w)-(PlayerX*screenWidth);
	gc.SetTileColorRGB(0,255,0);
	gc.DrawBox( PlayerX * screenWidth, yoffset+h, barLen, 1, 0, 0, 1, Texture'Solid');
	yoffset += ( h * 0.25 );
	for ( i = 0; i < allyCnt; i++ )
	{
		bLocalPlayer = (teamSE[i].PlayerID == thisPlayer.PlayerReplicationInfo.PlayerID);
		if ( bLocalPlayer )
			gc.SetTextColor( GoldColor );
		else
			gc.SetTextColor( GreenColor );
		yoffset += ylen;
		DrawNameAndScore( gc, teamSE[i], screenWidth, yoffset );
	}

	yoffset += (ylen*2);

	if ( thisPlayer.PlayerReplicationInfo.team == TEAM_UNATCO )
		teamStr = TeamNsfString;
	else
		teamStr = TeamUnatcoString;

	// Enemies
	enemyCnt = GetTeamList( thisPlayer, False );
	SortTeamScores( enemyCnt );
	gc.SetTextColor( RedColor );
	gc.GetTextExtent( 0, w, h, EnemiesString );
	gc.DrawText( PlayerX * screenWidth, yoffset, w, h, EnemiesString );
	fakeSE.PlayerName = EnemiesString $ " (" $ teamStr $ ")";
	LocalGetTeamTotals( enemyCnt, fakeSE.score, fakeSE.deaths, fakeSE.streak );
	DrawNameAndScore( gc, fakeSE, screenWidth, yoffset );
	gc.SetTileColorRGB(255,0,0);
	gc.DrawBox( PlayerX * screenWidth, yoffset+h, barLen, 1, 0, 0, 1, Texture'Solid');
	yoffset += ( h * 0.25 );

	for ( i = 0; i < enemyCnt; i++ )
	{
		yoffset += ylen;
		DrawNameAndScore( gc, teamSE[i], screenWidth, yoffset );
	}
}

function bool FindSpecialAttractionFor(Bot aBot)
{
	return false;
}

function SetAttractionStateFor(Bot aBot)
{
	if ( aBot.Enemy != None )
	{
		if ( !aBot.IsInState('FallBack') )
		{
			aBot.bNoClearSpecial = true;
			aBot.TweenToRunning(0.1);
			aBot.GotoState('FallBack','SpecialNavig');
		}
	}
	else if ( !aBot.IsInState('Roaming') )
	{
		aBot.bNoClearSpecial = true;
		aBot.TweenToRunning(0.1);
		aBot.GotoState('Roaming', 'SpecialNavig');
	}
}

function bool ChangeTeam(Pawn PawnToChange, int NewTeam)
{
   local int iSkin;
   local int CurTeam;
   local DeusExPlayer PlayerToChange;

   if (!ApproveTeam(NewTeam))
	   NewTeam = TEAM_AUTO;

   //DEUS_EX AMSD Autoteam midmatch shouldn't change my team.
   if (NewTeam == TEAM_AUTO)
   {
      if (PlayerPawn(PawnToChange) != None)
      {
         CurTeam = PlayerPawn(PawnToChange).PlayerReplicationInfo.Team;
         NewTeam = CurTeam;
      }
      else
         return false;
   }
   
   if (!Super.ChangeTeam(PawnToChange, NewTeam))
      return false;

   PlayerToChange = DeusExPlayer(PawnToChange);
   if (PlayerToChange == None)
      return false;

   if (NewTeam == TEAM_UNATCO)
   {
      for (iSkin = 0; iSkin < ArrayCount(PlayerToChange.MultiSkins); iSkin++)
      {
         PlayerToChange.MultiSkins[iSkin] = class'mpunatco'.Default.MultiSkins[iSkin];
      }
      PlayerToChange.CarcassType = class'mpunatco'.Default.CarcassType;
      PlayerToChange.Mesh = class'mpunatco'.Default.Mesh;
   }
   else if (NewTeam == TEAM_NSF)
   {
      for (iSkin = 0; iSkin < ArrayCount(PlayerToChange.MultiSkins); iSkin++)
      {
         PlayerToChange.MultiSkins[iSkin] = class'mpnsf'.Default.MultiSkins[iSkin];
      }
      PlayerToChange.CarcassType = class'mpnsf'.Default.CarcassType;
      PlayerToChange.Mesh = class'mpnsf'.Default.Mesh;
   }
   else
   {
      return false;
   }
   
   return true;
}

function SetBotOrders(Bot NewBot)
{
	local Pawn P, L;
	local int num, total;

	// only follow players, if there are any
	if (NumSupportingPlayer == 0) 
	{
		For ( P=Level.PawnList; P!=None; P= P.NextPawn )
			if ( P.IsA('PlayerPawn') && (P.PlayerReplicationInfo.Team == NewBot.PlayerReplicationInfo.Team)
				&& !P.IsA('Spectator') )
		{
			num++;
			if ( (L == None) || (FRand() < 1.0/float(num)) )
				L = P;
		}

		if ( L != None )
		{
			NumSupportingPlayer++;
			NewBot.SetOrders('Follow',L,true);
			return;
		}
	}
	num = 0;
	For ( P=Level.PawnList; P!=None; P= P.NextPawn )
		if ( P.bIsPlayer && (P.PlayerReplicationInfo.Team == NewBot.PlayerReplicationInfo.Team) )
		{
			total++;
			if ( (P != NewBot) && P.IsA('Bot') && (Bot(P).Orders == 'FreeLance') )
			{
				num++;
				if ( (L == None) || (FRand() < 1/float(num)) )
					L = P;
			}
		}
				
	if ( (L != None) && (FRand() < float(num)/float(total)) )
	{
		NewBot.SetOrders('Follow',L,true);
		return;
	}
	NewBot.SetOrders('Freelance', None,true);
}	

function ClearOrders(Pawn Leaving)
{
	local Pawn P;

	for ( P=Level.PawnList; P!=None; P=P.NextPawn )
		if ( P.IsA('Bot') && (Bot(P).OrderObject == Leaving) )
			Bot(P).SetOrders('Freelance', None);
}	

function GameOver()
{
   Super.GameOver();
}

defaultproperties
{
     EnemiesString="Enemies"
     AlliesString="Allies"
     VictoryConString1="Objective: First team that reaches "
     VictoryConString2=" kills wins the match."
     TimeLimitString1="Objective: Score the most kills before the clock ( "
     TimeLimitString2=" ) runs out!"
     TeamScoreString=" Team Score:"
     bAutoInstall=False
     SkillsTotal=5000
     SkillsAvail=5000
     bTeamGame=True
     DefaultPlayerClass=Class'DeusEx.Mpunatco'
}
